*Title: activeCollab Installation
*Slug: installation

================================================================

<{note}>Whenever installing or upgrading activeCollab and uploading files using FTP, always use Binary transfer mode. Using any other mode can cause the files to become corrupted and render them invalid.<{/note}>

The activeCollab installation can be completed in six simple steps:

<{step num=1}>**Meeting system requirements**<{/step}>

Before starting the installation, make sure that your server meets the activeCollab <{page name="system-requirements"}>System Requirements<{/page}>. activeCollab works well on most platforms which have a web server with PHP support and MySQL database.

To check if your system meets the system requirements, use the <{term}>probe.php<{/term}> script, designed specifically for this purpose. Here are brief instructions on how to work with this script:

- Download the probe.php.zip file from our <a href="https://github.com/activecollab/activecollab-probe">Github repository</a>.
- Unpack and upload the probe.php file to your server.
- Run it through your web browser.
- Open the probe.php file in your text editor and set the database connection parameters in the Database Settings section at the beginning of the file. Once these parameters are set, save the file on the server and run it again. It will run a check of your platform and additionally try to connect to the database to see if it meets the system requirements.

<{step num=2}>**Creating a Database**<{/step}>

The activeCollab installer will not create a database for you, so make sure that you have a database available for your activeCollab installation before continuing with the installation process. If you do not have a database, you can **create it by using MySQL administration tools** (eg. phpMyAdmin) or contact your system administrator to create a database for you.

When the database is created, make sure to write down the following details:

- The **database host name** (usually "localhost") as well as the database **username and password**;
- The **name of the database that you have just created**.

The activeCollab installer will require those details and the installation cannot be performed without them.

<{step num=3}>**Downloading activeCollab**<{/step}>

Before you can install activeCollab, you will need to download the activeCollab installation package from <a href="https://www.activecollab.com/my-profile">your profile page on www.activeCollab.com</a>. To be able to see and download the installation package, log in with the same account that was used to purchase the license.

<{step num=4}>**Uploading Files to the Server**<{/step}>

After downloading and unpacking the installation package using a ZIP extraction utility, you will see the following files and folders:

- <{path}>/for-upload<{/path}> - activeCollab files that you need to upload to your server.
- <{code}>license.txt<{/code}> - the activeCollab End User license agreement.
- <{code}>readme.txt<{/code}> - basic information about activeCollab and links to additional resources.
- <{code}>release-notes.txt<{/code}> - information about both current and previous releases.

You do not need to upload all these files to your server. Instead, you should upload only the contents of the <{path}>/for-upload<{/path}> folder.

<{step num=5}>**Running the Installer Tool**<{/step}>

Once you have uploaded files from the <{path}>/for-upload<{/path}> folder to your server, you can run the activeCollab installer. The installer tool can be run in any web browser. In fact, if you try to open any of the activeCollab pages at this point, the system will display the installer tool instead.

Before commencing the installation process, the activeCollab installer will first validate your environment, and then start the installation process. During installation, the activeCollab installer will require:

- Database connection parameters that prepared in Step 2.
- Email address and password of the administrator account (usually your own account).
- Your acceptance of the activeCollab License Agreement.

If the installation is run properly, the system will display several OK messages and provide you with the link to your login screen, where you can use the above mentioned administrator email address and password to log in to the system.

<{step num=6}>**Verifying That the System is Working Properly**<{/step}>

After you have run the installation tool, you can visit your new activeCollab setup. If everything has gone well, the system will display the login screen where you can log in using the administrator username and password, which you have provided during the installation.

If you do not see the login screen or see an error message or blank page instead, please contact our support team.

<{step num=7}>**Importing the Data form Your Free Trial Account**<{/step}>

If you were evaluating activeCollab before you have decided to purchase the license, you can have exactly the same setup as you created in your Free Trial account. All you need to do is to import your demo database into your self-hosted activeCollab.

Your data will be available on your www.activeCollab.com profile page under the <{option}>Request Backup<{/option}> link.

Now that you have the exported data, it will have to be imported into your activeCollab:

- Upload the contents of all directories from the archive file to the respective directories in your activeCollab setup (overwrite the existing files).
- Delete all the tables from the activeCollab database and import the data from .sql file located in the archive.
- Delete the all files having .php extension from <{path}>/cache<{/path}> directory.
- Delete the all files having .php extension from <{path}>/compile<{/path}> directory.
- Edit <{path}>/config/config.php<{/path}> and set the table prefix to your instance name. For example, if your demo instance was called http://mydemo.manageprojects.com, then you should set the table prefix to "mydemo_".

After completing all of the above steps, you should be able to see all your data from the Free Trial account in your installed activeCollab.

If you have any difficulties, feel free to contact us, and we will gladly assist you with your activeCollab installation.